<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contact extends Model 
{

    protected $table = 'contacts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('home', 'office', 'mobile', 'fax', 'user_id');
    protected $visible = array('home', 'office', 'mobile', 'fax', 'user_id');

    public function user()
    {
        return $this->hasOne('App\User', 'user_id');
    }

}